<?xml version="1.0" encoding="UTF-8"?>
<!-- El objetivo de este archivo SLD, es el de simbolizar la entidad urbanística correspondiente según lo indicado en la "Instrucción técnica de estandarización y normalización de instrumentos de planeamiento (ITU-PL1)". Antes de su uso deberá revisar las etiquetas que hacen referencia a los campos existentes en las tablas de datos, especialmente los destinados a simbolizar por categorías, los de elementos alfanuméricos y los de geometría. Su definición puede admitir variantes y ser mejorada. Si es el caso, por favor, comparta su conocimiento para que futuros usuarios puedan beneficiarse. Gracias. | Murcia, mayo de 2024 | SERVICIO DE URBANISMO | https://www.urbmurcia.es/web/urbmurcia/contacto | -->
<sld:StyledLayerDescriptor xmlns="http://www.opengis.net/sld" xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" xmlns:gml="http://www.opengis.net/gml" version="1.0.0">
	<sld:NamedLayer>
		<sld:Name>24_unidades_gestion</sld:Name>
		<sld:UserStyle>
			<sld:Name>24_unidades_gestion</sld:Name>
			<sld:FeatureTypeStyle>
				<sld:Name>poligono</sld:Name>
				<sld:Rule>
					<sld:Name>poligono</sld:Name>
					<sld:Title>Unidades de gestión</sld:Title>
					<sld:Abstract/>
					<!-- <sld:MinScaleDenominator>1000.0</sld:MinScaleDenominator> -->
					<!-- <sld:MaxScaleDenominator>2000.0</sld:MaxScaleDenominator> -->
					<sld:PolygonSymbolizer>
						<sld:Stroke>
							<sld:CssParameter name="stroke">#B40032</sld:CssParameter>
							<sld:CssParameter name="stroke-width">1.5</sld:CssParameter>
							<sld:CssParameter name="stroke-dasharray">7.0 4.0</sld:CssParameter>
						</sld:Stroke>
					</sld:PolygonSymbolizer>
					<sld:TextSymbolizer>
						<sld:Label>
							<ogc:PropertyName>Unidad</ogc:PropertyName>
						</sld:Label>
						<sld:Font>
							<sld:CssParameter name="font-family">Liberation Mono</sld:CssParameter>
							<sld:CssParameter name="font-size">12</sld:CssParameter>
							<sld:CssParameter name="font-style">normal</sld:CssParameter>
							<sld:CssParameter name="font-weight">normal</sld:CssParameter>
						</sld:Font>
						<sld:LabelPlacement>
							<sld:PointPlacement>
								<sld:AnchorPoint>
									<sld:AnchorPointX>0.5</sld:AnchorPointX>
									<sld:AnchorPointY>0.5</sld:AnchorPointY>
								</sld:AnchorPoint>
								<sld:Displacement>
									<sld:DisplacementX>0.0</sld:DisplacementX>
									<sld:DisplacementY>0.0</sld:DisplacementY>
								</sld:Displacement>
							</sld:PointPlacement>
						</sld:LabelPlacement>
						<sld:Fill>
							<sld:CssParameter name="fill">#B40032</sld:CssParameter>
						</sld:Fill>
						<sld:VendorOption name="graphic-margin">0</sld:VendorOption>
						<sld:VendorOption name="graphic-resize">stretch</sld:VendorOption>
					</sld:TextSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>AA</sld:Name>
					<sld:Title>(AA) Actuación aislada</sld:Title>
					<sld:Abstract/>
					<!-- <sld:MinScaleDenominator>1000.0</sld:MinScaleDenominator> -->
					<!-- <sld:MaxScaleDenominator>2000.0</sld:MaxScaleDenominator> -->
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>Unidad</ogc:PropertyName>
							<ogc:Literal>AA</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>UAC</sld:Name>
					<sld:Title>(UAC) Unidad actuación en consolidado</sld:Title>
					<sld:Abstract/>
					<!-- <sld:MinScaleDenominator>1000.0</sld:MinScaleDenominator> -->
					<!-- <sld:MaxScaleDenominator>2000.0</sld:MaxScaleDenominator> -->
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>Unidad</ogc:PropertyName>
							<ogc:Literal>UAC</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>UA</sld:Name>
					<sld:Title>(UA) Unidad actuación en sin consolidar</sld:Title>
					<sld:Abstract/>
					<!-- <sld:MinScaleDenominator>1000.0</sld:MinScaleDenominator> -->
					<!-- <sld:MaxScaleDenominator>2000.0</sld:MaxScaleDenominator> -->
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>Unidad</ogc:PropertyName>
							<ogc:Literal>UA</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</sld:Rule>
			</sld:FeatureTypeStyle>
		</sld:UserStyle>
	</sld:NamedLayer>
</sld:StyledLayerDescriptor>
